/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DPCDCommandType;
import com.quantumdata.busmon.parser.DPCDMessage;
import com.quantumdata.busmon.parser.DPCDMessageType;

public class DPCDRequestMessage
extends DPCDMessage {
    private int aAddress = 0;
    private int aDataLength = 0;

    public DPCDRequestMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, int n, int n2) {
        super(dPCDMessageType, dPCDCommandType);
        this.aAddress = n;
        this.aDataLength = n2;
    }

    public DPCDRequestMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, int n, int n2, boolean bl) {
        this(dPCDMessageType, dPCDCommandType, n, n2);
        this.aIsMOT = bl;
    }

    public DPCDRequestMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, int n, byte[] byArray) {
        super(dPCDMessageType, dPCDCommandType, byArray);
        this.aAddress = n;
        this.aDataLength = byArray.length;
    }

    public DPCDRequestMessage(DPCDMessageType dPCDMessageType, DPCDCommandType dPCDCommandType, int n, byte[] byArray, boolean bl) {
        this(dPCDMessageType, dPCDCommandType, n, byArray);
        this.aIsMOT = bl;
    }

    public int getAddress() {
        return this.aAddress;
    }

    public int getDataLength() {
        return this.aDataLength;
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("Message Type:  " + this.getMessageTypeText() + "\n");
        stringBuffer.append("Command Type:  " + this.getCommandTypeText() + "\n");
        stringBuffer.append("Direction:  " + this.getDirection() + "\n");
        stringBuffer.append("Middle of Transaction:  " + this.getMOT() + "\n");
        stringBuffer.append("Address:  0x" + Integer.toHexString(this.getAddress()) + "\n");
        if (this.hasData()) {
            stringBuffer.append(this.getDataAsHexString());
        } else {
            stringBuffer.append("This message contains no data");
        }
        return stringBuffer.toString();
    }
}

